/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.effects;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.effects.IEffectState;
import org.orecruncher.dsurround.client.effects.IParticleHelper;
import org.orecruncher.dsurround.client.effects.ISoundHelper;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEffect;

@SideOnly(value=Side.CLIENT)
public class EffectStateBase
implements IEffectState {
    protected static final IParticleHelper NULL_PARTICLE_HELPER = particle -> {};
    protected static final ISoundHelper NULL_SOUND_HELPER = new ISoundHelper(){

        @Override
        public boolean playSound(@Nonnull ISoundInstance sound2) {
            return false;
        }

        @Override
        public void stopSound(@Nonnull ISoundInstance sound2) {
        }
    };
    protected final IParticleHelper particleHelper;
    protected final ISoundHelper soundHelper;

    protected EffectStateBase() {
        this(NULL_PARTICLE_HELPER, NULL_SOUND_HELPER);
    }

    public EffectStateBase(@Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        this.particleHelper = ph;
        this.soundHelper = sh;
    }

    @Override
    public void addParticle(@Nonnull Particle particle) {
        this.particleHelper.addParticle(particle);
    }

    @Override
    public boolean playSound(@Nonnull ISoundInstance sound2) {
        return this.soundHelper.playSound(sound2);
    }

    public void stopSound(@Nonnull ISoundInstance sound2) {
        this.soundHelper.stopSound(sound2);
    }

    @Override
    @Nonnull
    public ISoundInstance createSound(@Nonnull SoundEffect se, @Nonnull Entity player2) {
        return se.createTrackingSound(player2, false);
    }

    public boolean isActivePlayer(@Nonnull Entity player2) {
        EntityPlayer ep = this.thePlayer();
        return ep.func_145782_y() == player2.func_145782_y();
    }

    @Override
    @Nonnull
    public EntityPlayer thePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

